/*
             LUFA Library
     Copyright (C) Dean Camera, 2008.
              
  dean [at] fourwalledcubicle [dot] com
      www.fourwalledcubicle.com
*/

/*
  Copyright 2008  Dean Camera (dean [at] fourwalledcubicle [dot] com)

  Permission to use, copy, modify, and distribute this software
  and its documentation for any purpose and without fee is hereby
  granted, provided that the above copyright notice appear in all
  copies and that both that the copyright notice and this
  permission notice and warranty disclaimer appear in supporting
  documentation, and that the name of the author not be used in
  advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  The author disclaim all warranties with regard to this
  software, including all implied warranties of merchantability
  and fitness.  In no event shall the author be liable for any
  special, indirect or consequential damages or any damages
  whatsoever resulting from loss of use, data or profits, whether
  in an action of contract, negligence or other tortious action,
  arising out of or in connection with the use or performance of
  this software.
*/

/** \file
 *
 *  Header file for Descriptors.c.
 */

#ifndef _DESCRIPTORS_H_
#define _DESCRIPTORS_H_

	/* Includes: */
		#include <LUFA/Drivers/USB/USB.h>

	/* Macros: */
		/** Descriptor type value for a DFU class functional descriptor. */
		#define DTYPE_DFUFunctional               0x21
		
		/** DFU attribute mask, indicating that the DFU device will detach and re-attach when a DFU_DETACH
		 *  command is issued, rather than the host issing a USB Reset.
		 */
		#define ATTR_WILL_DETATCH                 (1 << 3)

		/** DFU attribute mask, indicating that the DFU device can communicate during the manefestation phase
		 *  (memory programming phase).
		 */
		#define ATTR_MANEFESTATION_TOLLERANT      (1 << 2)
		
		/** DFU attribute mask, indicating that the DFU device can accept DFU_UPLOAD requests to send data from
		 *  the device to the host.
		 */		
		#define ATTR_CAN_UPLOAD                   (1 << 1)

		/** DFU attribute mask, indicating that the DFU device can accept DFU_DNLOAD requests to send data from
		 *  the host to the device.
		 */		
		#define ATTR_CAN_DOWNLOAD                 (1 << 0)

		#if defined(__AVR_AT90USB1286__)
			#define PRODUCT_ID_CODE               0x2FFB

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x97
			#define SIGNATURE_BYTE_3              0x82
		#elif defined(__AVR_AT90USB1287__)
			#define PRODUCT_ID_CODE               0x2FFB
			
			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x97
			#define SIGNATURE_BYTE_3              0x82
		#elif defined(__AVR_AT90USB646__)
			#define PRODUCT_ID_CODE               0x2FF9

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x96
			#define SIGNATURE_BYTE_3              0x82
		#elif defined(__AVR_AT90USB647__)
			#define PRODUCT_ID_CODE               0x2FF9

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x96
			#define SIGNATURE_BYTE_3              0x82
		#elif defined(__AVR_AT90USB162__)
			#define PRODUCT_ID_CODE               0x2FFA

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x94
			#define SIGNATURE_BYTE_3              0x82
		#elif defined(__AVR_AT90USB82__)
			#define PRODUCT_ID_CODE               0x2FF7

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x94
			#define SIGNATURE_BYTE_3              0x82
		#elif defined(__AVR_ATmega32U6__)
			#define PRODUCT_ID_CODE               0x2FFB

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x95
			#define SIGNATURE_BYTE_3              0x88
		#elif defined(__AVR_ATmega32U4__)
			#define PRODUCT_ID_CODE               0x2FF4

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x95
			#define SIGNATURE_BYTE_3              0x87	
		#elif defined(__AVR_ATmega16U4__)
			#define PRODUCT_ID_CODE               0x2FF3

			#define SIGNATURE_BYTE_1              0x1E
			#define SIGNATURE_BYTE_2              0x94
			#define SIGNATURE_BYTE_3              0x88
		#else
			#error The selected AVR part is not currently supported by this bootloader.
		#endif
		
		#if !defined(PRODUCT_ID_CODE)
			#error Current AVR model is not supported by this bootloader.
		#endif
	
	/* Type Defines: */
		/** Type define for a DFU class function descriptor. This descriptor gives DFU class information
		 *  to the host when read, indicating the DFU device's capabilities.
		 */
		typedef struct
		{
			USB_Descriptor_Header_t               Header; /**< Standard descriptor header structure */
			
			uint8_t                               Attributes; /**< DFU device attributes, a mask comprising of the
			                                                    *  ATTR_* macros listed in this source file
			                                                    */
			uint16_t                              DetatchTimeout; /**< Timeout in milliseconds between a USB_DETACH
			                                                        *  command being issued and the device detaching
			                                                        *  from the USB bus
			                                                        */																	
			uint16_t                              TransferSize; /**< Maximum number of bytes the DFU device can accept
			                                                      *  from the host in a transaction
			                                                      */			
			uint16_t                              DFUSpecification;	/**< BCD packed DFU specification number this DFU
			                                                          *  device complies with
			                                                          */
		} USB_DFU_Functional_Descriptor_t;
	
		/** Type define for the device configuration descriptor structure. This must be defined in the
		 *  application code, as the configuration descriptor contains several sub-descriptors which
		 *  vary between devices, and which describe the device's usage to the host.
		 */
		typedef struct
		{
			USB_Descriptor_Configuration_Header_t Config;
			USB_Descriptor_Interface_t            DFUInterface;
			USB_DFU_Functional_Descriptor_t       DFUFunctional;
		} USB_Descriptor_Configuration_t;
		
	/* Function Prototypes: */
		uint16_t USB_GetDescriptor(const uint16_t wValue, const uint8_t wIndex, void** const DescriptorAddress)
		                           ATTR_WARN_UNUSED_RESULT ATTR_NON_NULL_PTR_ARG(3);

#endif
